<?php

namespace App\Http\Controllers\AppHandler;

use App\Http\Controllers\Controller;
use App\Models\AUser;
use App\Models\DB_Amount;
use App\Models\DB_Daily;
use App\Models\DB_Game;
use App\Models\DB_Payment;
use App\Models\DB_PyRequest;
use App\Models\DB_QuickBonu;
use App\Models\DB_ReadArticle;
use App\Models\DB_Settings;
use App\Models\DB_Task;
use App\Models\DB_Tracking;
use App\Models\DB_WallCategory;
use App\Models\DB_Wallpaper;
use App\Models\ModelsDBanner;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;

class AppData extends Controller
{


public static function get_banner(Request $request)
{
    //get banners list
    $banners = ModelsDBanner::where('status', true)->get();
    return response()->json([
        'success' => true,
        'banners' => $banners
    ]);

}


public static function get_dailydata(Request $request)
{
    $u_id = $request->input('u_id');
    $streaks = DB_Daily::where('u_id', $u_id)->get();
    $user = AUser::where('u_id', $u_id)->first();
    $response = [
        'success' => true,
        'message' => 'successfully!',
        'day_collected' => $user->day_collected ?? 0,
        'streaks' => $streaks,
    ];
    return response()->json($response, 200);

}


public static function get_quiztask(Request $request)
{

    $u_id = $request->input('u_id');
    $user = AUser::where('u_id', $u_id)->first();
    $today = now()->toDateString();
    $work_type = 'quick_bonus_task';

    //setting
    $config = json_decode(DB_Settings::where('id', 1)->value('play_quiz'), true);
    $daily_limit = isset($config['daily_limit']) ? (int) $config['daily_limit'] : 0;

    
    //quick task
    $completedToday = DB_Task::where('user_id', $user)
        ->where('task_type', $work_type)
        ->whereDate('created_at', $today)
        ->count();

    if ($completedToday >= $daily_limit) {
        $user->update(['play_quiz_task' => 1]);
    }
    $user->update(['play_quiz_task' => 0]);
    
    $response = [
        'success' => true,
        'message' => 'successfully!',
        'user' => $user
    ];

    return response()->json($response, 200);

}

public static function get_reward_vault(Request $request)
{

    $u_id = $request->input('u_id');
    $user = AUser::where('u_id', $u_id)->first();
    $today = now()->toDateString();
    $work_type = 'reward_vault_task';

    //setting
    $config = json_decode(DB_Settings::where('id', 1)->value('reward_vault'), true);
    $daily_limit = isset($config['daily_limit']) ? (int) $config['daily_limit'] : 0;

    
    //quick task
    $completedToday = DB_Task::where('user_id', $user)
        ->where('task_type', $work_type)
        ->whereDate('created_at', $today)
        ->count();

    if ($completedToday >= $daily_limit) {
        $user->update(['reward_vault_task' => 1]);
    }
    $user->update(['reward_vault_task' => 0]);
    
    $response = [
        'success' => true,
        'message' => 'successfully!',
        'user' => $user,
        'total_done' => $completedToday
    ];

    return response()->json($response, 200);

}



public static function get_pyament_methods(Request $request)
{
 
    $u_id = $request->input('u_id');
    $user = AUser::where('u_id', $u_id)->first();
    $payment = DB_Payment::orderBy('created_at', 'desc')->get();
    $response = [
        'success' => true,
        'message' => 'successfully!',
        'payment' => $payment,
        'user' => $user
    ];
    return response()->json($response, 200);

}

public static function send_redeem_request(Request $request)
{
 
    $u_id = $request->input('uid');
    $requiredCoin = $request->input('py_rcoin');
    $op1 = $request->input('op1');
    $op2 = $request->input('op2');
    $py_title = $request->input('py_title');
    $py_rcoin = $request->input('py_rcoin');
    $py_amout = $request->input('py_amout');
    $py_currency = $request->input('py_currency');
    $name = $request->input('name');
    

    $user = AUser::where('u_id', $u_id)->first();

    if ($user) {
 
        if ($user->point >= $requiredCoin) {
            $user->point = $user->point - $requiredCoin;
            $user->save();
            
            $py_req = new DB_PyRequest();
            $py_req->uid = $u_id;
            $py_req->op1 = $op1;
            $py_req->op2 = $op2;
            $py_req->py_title = $py_title;
            $py_req->py_rcoin = $py_rcoin;
            $py_req->py_amout = $py_amout;
            $py_req->py_currency = $py_currency;
            $py_req->name = $name;
            
            $py_req->save();

            return response()->json([
                'success' => true,
                'message' => "Redeem Request Sent Successfully !!",
                'user' => $user
            ], 200);

        } else {
            return response()->json([
                'success' => false,
                'message' => "Insufficient coins. You have {$user->point}, need $requiredCoin"
            ]);
        }

    } else {
        return response()->json([
            'success' => false,
            'message' => "User not found"
        ]);
    }


 


}

public static function get_earnhistory(Request $request)
{

    $u_id = $request->input('u_id');
    $track = DB_Tracking::where('u_id', $u_id)
        ->latest()
        ->limit(1000)
        ->get();
    $response = [
        'success' => true,
        'message' => 'successfully!',
        'track' => $track
    ];

    return response()->json($response, 200);

}

public static function get_redeems(Request $request)
{

    $u_id = $request->input('u_id');
    $track = DB_PyRequest::where('uid', $u_id)
        ->latest()
        ->limit(1000)
        ->get();
    $response = [
        'success' => true,
        'message' => 'successfully!',
        'redeems' => $track
    ];

    return response()->json($response, 200);

}

public static function delete_account(Request $request)
{

    $u_id = $request->input('u_id');
    $user = AUser::where('u_id', $u_id)->first();
    if ($user) {
        $user->delete();
        return response()->json([
            'status' => 'success',
            'message' => 'User deleted successfully.'
        ]);
    } else {
        return response()->json([
            'status' => 'error',
            'message' => 'User not found.'
        ], 404);
    }

    $response = [
        'success' => true,
        'message' => 'successfully!',
    ];
    return response()->json($response, 200);


}
 
 
public static function generate_caption(Request $request)
{
    $request->validate([
        'u_id'   => 'required|string',
        'promt'  => 'required|string',
        'lang'   => 'nullable|string',
        'tone'   => 'nullable|string',
        'length' => 'nullable|string|in:Short,Medium,Long',
        'req_coin' => 'nullable|numeric'
    ]);

    $u_id    = $request->input('u_id');
    $promt   = $request->input('promt');
    $lang    = ucfirst(strtolower($request->input('lang') ?? 'English'));
    $tone    = $request->input('tone') ?? 'friendly';
    $length  = $request->input('length') ?? 'Short';
    $req_coin = $request->input('req_coin', 0);

    $config = json_decode(DB_Settings::where('id', 1)->value('aicaption_config'), true);
    $apiKey = isset($config['ai_apikey']) ? (string) $config['ai_apikey'] : '0';
    $selectedModel = isset($config['ai_model']) ? (string) $config['ai_model'] : '0';
   
 

    $apiUrl = "https://openrouter.ai/api/v1/chat/completions";

    try {
        $messages = [
            [
                "role" => "system",
                "content" => "You are a multilingual expert caption generator for Facebook.
                - Write *only* in the exact language requested ($lang).
                - Use the correct native script (বাংলা, हिन्दी, العربية, etc.).
                - Never include English, explanations, or reasoning.
                - Output only the final caption text, nothing else.
                - Always complete your output with the final caption."
            ],
            [
                "role" => "user",
                "content" => "Write a $length, $tone Facebook caption in $lang about: $promt.
                Respond with only the caption — no explanation, no tags, no translation."
            ]
        ];

        $response = Http::withHeaders([
            'Authorization' => "Bearer $apiKey",
            'Content-Type'  => 'application/json'
        ])->post($apiUrl, [
            'model'        => $selectedModel,
            'messages'     => $messages,
            'max_tokens'   => 100,
            'temperature'  => 0.9,
            'stop'         => ["Reasoning:", "Explanation:", "\n\n"]
        ]);

        $data = $response->json();

        if ($response->successful()) {
            $content = $data['choices'][0]['message']['content'] ?? '';
            $reason  = $data['choices'][0]['message']['reasoning'] ?? '';

            if (empty($content) && !empty($reason)) {
                $content = $reason;
            }

            // Clean unwanted content
            $clean = preg_replace('/<think>.*?<\/think>/s', '', $content);
            $clean = preg_replace('/[\*\#\[\]\(\)\{\}\"\']/', '', $clean);
            $clean = trim(preg_replace('/\s+/', ' ', $clean));

            $captions = array_values(array_filter(array_map('trim', preg_split("/[\r\n]+/", $clean))));

            // Deduct user coin
            $user = AUser::where('u_id', $u_id)->first();
            if (!$user) {
                return response()->json(['status' => 'error', 'message' => 'User not found']);
            }
            if ($req_coin > 0) {
                $user->decrement('point', $req_coin);
            }

            return response()->json([
                'status'   => 'success',
                'u_id'     => $u_id,
                'lang'     => $lang,
                'model'    => $selectedModel,
                'caption'  => $captions[0] ?? $clean,
                'coin'     => $user->point
            ]);
        }

        return response()->json([
            'status'  => 'error',
            'message' => 'OpenRouter API error: ' . json_encode($data)
        ], 500);

    } catch (\Exception $e) {
        return response()->json([
            'status'  => 'error',
            'message' => 'Server error: ' . $e->getMessage()
        ], 500);
    }
}


public static function generate_hashtags(Request $request)
{
    $request->validate([
        'u_id'     => 'required|string',
        'promt'    => 'required|string',
        'lang'     => 'nullable|string',
        'tone'     => 'nullable|string',
        'length'   => 'nullable|string|in:Short,Medium,Long',
        'req_coin' => 'nullable|numeric'
    ]);

    $u_id     = $request->input('u_id');
    $promt    = $request->input('promt');
    $lang     = ucfirst(strtolower($request->input('lang') ?? 'English'));
    $tone     = $request->input('tone') ?? 'friendly';
    $length   = $request->input('length') ?? 'Short';
    $req_coin = $request->input('req_coin', 0);

    $config = json_decode(DB_Settings::where('id', 1)->value('aicaption_config'), true);
    $apiKey = isset($config['ai_apikey']) ? (string) $config['ai_apikey'] : '0';
    $selectedModel = isset($config['ai_model']) ? (string) $config['ai_model'] : 'tngtech/deepseek-r1t-chimera:free';

    $apiUrl = "https://openrouter.ai/api/v1/chat/completions";

    try {
        $messages = [
            [
                "role" => "system",
                "content" => "You are a multilingual expert hashtag generator for social media.
                - Write *only* in the exact language requested ($lang).
                - Use correct native script (বাংলা, हिन्दी, العربية, etc.).
                - Never include English words, captions, explanations, or reasoning.
                - Output only hashtags separated by spaces or new lines."
            ],
            [
                "role" => "user",
                "content" => "Generate 5-$length hashtags in $lang for: $promt
                Respond only with hashtags — no caption, no explanation, no translation."
            ]
        ];

        $response = Http::withHeaders([
            'Authorization' => "Bearer $apiKey",
            'Content-Type'  => 'application/json'
        ])->post($apiUrl, [
            'model'       => $selectedModel,
            'messages'    => $messages,
            'max_tokens'  => 100,
            'temperature' => 0.9,
            'stop'        => ["Reasoning:", "Explanation:", "\n\n"]
        ]);

        $data = $response->json();

        if ($response->successful()) {
            $content = $data['choices'][0]['message']['content'] ?? '';
            $reason  = $data['choices'][0]['message']['reasoning'] ?? '';

            if (empty($content) && !empty($reason)) {
                $content = $reason;
            }

            // Clean AI output
            $clean = preg_replace('/<think>.*?<\/think>/s', '', $content);
            $clean = preg_replace('/[\*\[\]\(\)\{\}\"\']/', '', $clean);
            $clean = trim(preg_replace('/\s+/', ' ', $clean));

            // Split into hashtags array
            $hashtags = array_values(array_filter(array_map('trim', preg_split("/[\r\n ]+/", $clean))));

            // Deduct coins
            $user = AUser::where('u_id', $u_id)->first();
            if (!$user) {
                return response()->json(['status' => 'error', 'message' => 'User not found']);
            }
            if ($req_coin > 0) {
                $user->decrement('point', $req_coin);
            }

            return response()->json([
                'status'    => 'success',
                'u_id'      => $u_id,
                'lang'      => $lang,
                'model'     => $selectedModel,
                'caption'  => $hashtags,
                'coin'      => $user->point
            ]);
        }

        return response()->json([
            'status'  => 'error',
            'message' => 'OpenRouter API error: ' . json_encode($data)
        ], 500);

    } catch (\Exception $e) {
        return response()->json([
            'status'  => 'error',
            'message' => 'Server error: ' . $e->getMessage()
        ], 500);
    }
}


public static function get_amountpy(Request $request)
{
   
    $u_id = $request->input('u_id');
    $item_id = $request->input('item_id');

    $user = AUser::where('u_id', $u_id)->first();
    $payment = DB_Amount::orderBy('created_at', 'desc')->where('amount_id', $item_id)->get();
    $response = [
        'success' => true,
        'message' => 'successfully!',
        'payment' => $payment,
        'user' => $user
    ];
    return response()->json($response, 200);

}



public static function get_leader(Request $request)
{
    $today = \Carbon\Carbon::today();

    $topEarners = DB::table('db_tracking')
        ->select(
            'auser.u_id',
            'auser.name',
            'auser.image',
            'auser.total_refer',
            DB::raw('SUM(db_tracking.reward) as total_earned')
        )
        ->join('auser', 'auser.u_id', '=', 'db_tracking.u_id')
        ->whereDate('db_tracking.created_at', $today)
        ->groupBy('auser.u_id', 'auser.name', 'auser.image', 'auser.total_refer')
        ->orderByDesc('total_earned')
        ->limit(50)
        ->get();

    // ➕ Add rank number manually
    $ranked = $topEarners->values()->map(function ($item, $index) {
        $item->rank = $index + 1;
        return $item;
    });

    return response()->json([
        'status' => 'success',
        'data' => $ranked
    ]);
}




}
