
<x-header>
 
    <!-- Main Content Wrapper -->
    <main class="main-content w-full px-[var(--margin-x)] pb-8">
        <div
          class="mt-4 grid grid-cols-1 gap-4 sm:mt-5 sm:gap-5 lg:mt-6 lg:gap-6"
        >
        <div class="col-span-12 lg:col-span-8">
          @if(session('status-success'))
          <div class="alert flex rounded-lg bg-success px-4 py-4 text-white sm:px-5 mb-3 sess_msg">
          {{ session('status-success') }}
          </div>
          @endif
          
          <div class="grid grid-cols-12 gap-4 sm:gap-5 lg:gap-6">
          <div class="col-span-12 lg:col-span-3">
           <div class="card">
              <div class="border-b border-slate-200 p-4 dark:border-navy-500 sm:px-5">
                <h2 class="font-medium tracking-wide text-slate-700 line-clamp-1 dark:text-navy-100 lg:text-base">
               Game Management
                </h2>
              </div>
              <div class="p-4 sm:px-5">
               
              </div>
            </div>
          </div>
          
          <div class="col-span-12 lg:col-span-8">
                     
          <div class="card">
            <div class="flex flex-col items-center space-y-4 border-b border-slate-200 p-4 dark:border-navy-500 sm:flex-row sm:justify-between sm:space-y-0 sm:px-5">
              <h2 class="text-lg font-medium tracking-wide text-slate-700 dark:text-navy-100">
                 
              </h2>
              <div class="flex justify-center space-x-2">
                <a href="{{ url('/admin/users'); }}" class="btn min-w-[7rem] border border-slate-300 font-medium text-slate-800 hover:bg-slate-150 focus:bg-slate-150 active:bg-slate-150/80 dark:border-navy-450 dark:text-navy-50 dark:hover:bg-navy-500 dark:focus:bg-navy-500 dark:active:bg-navy-500/90">
                  Cancel
                </a>
                <button style="    background-color: #10b981;" class="btn min-w-[7rem] bg-primary font-medium text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90"
                form="myform"
                type="submit">
                Save
                </button>
              </div>
            </div>

            <div class="p-4 sm:p-5">
              
              <div class="my-7 h-px bg-slate-200 dark:bg-navy-500"></div>
              <form method="POST" action="{{ url('/admin/game_settingupdate'); }}" id="myform" enctype="multipart/form-data">
              @csrf
              @METHOD('POST')
              <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">

            
                    @php
                    $settings = json_decode($settings->game_config, true);
                    @endphp

                    
                    <label class="block">
                        <span>Game Win Reward Minimum</span>
                        <span class="relative mt-1.5 flex">
                            <input class="form-input peer w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                            placeholder="Enter name"
                            type="number"
                            name="game_winreward_min"
                            value="{{ $settings['game_winreward_min'] ?? '' }}">
                            <span class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                            <i class="fa-regular fa-user text-base"></i>
                            </span>
                        </span>
                    </label>


                    <label class="block">
                        <span>Game Win Reward Maximum</span>
                        <span class="relative mt-1.5 flex">
                            <input class="form-input peer w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                            placeholder="Enter name"
                            type="number"
                            name="game_winreward_max"
                            value="{{ $settings['game_winreward_max'] ?? '' }}">
                            <span class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                            <i class="fa-regular fa-user text-base"></i>
                            </span>
                        </span>
                    </label>




                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2"> Reward Ad (Fallback 1)</label>
                        <select name="fallback_1" class="form-select w-full rounded-lg border border-gray-300 dark:border-gray-600 bg-transparent px-4 py-2 focus:border-blue-600 dark:focus:border-blue-400">
                                      

                            <option value="{{ $settings['fallback_1'] ?? '' }}" selected>{{ $settings['fallback_1'] ?? '' }}</option>
                            <option value="Facebook"  {{ $settings['fallback_1'] ?? '' }}>Facebook</option>
                            <option value="Admob" {{ $settings['fallback_1'] ?? '' }}>Admob</option>
                            <option value="Applovin" {{ $settings['fallback_1'] ?? '' }}>Applovin</option>
                            <option value="Vungle" {{ $settings['fallback_1'] ?? '' }}>Vungle</option>
                            <option value="InMobi" {{ $settings['fallback_1'] ?? '' }}>InMobi</option>
                      
                            </select>
                    </div>
 

                
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2"> Reward Ad (Fallback 2)</label>
                        <select name="fallback_2" class="form-select w-full rounded-lg border border-gray-300 dark:border-gray-600 bg-transparent px-4 py-2 focus:border-blue-600 dark:focus:border-blue-400">
                                     

                            <option value="{{ $settings['fallback_2'] ?? '' }}" selected>{{ $settings['fallback_2'] ?? '' }}</option>
                            <option value="Facebook"  {{ $settings['fallback_2'] ?? '' }}>Facebook</option>
                            <option value="Admob" {{ $settings['fallback_2'] ?? '' }}>Admob</option>
                            <option value="Applovin" {{ $settings['fallback_2'] ?? '' }}>Applovin</option>
                            <option value="Vungle" {{ $settings['fallback_2'] ?? '' }}>Vungle</option>
                            <option value="InMobi" {{ $settings['fallback_2'] ?? '' }}>InMobi</option>
                      
                      
                          </select>
                    </div>
 
            
           
              
                    

  
              </div>
            </form>
             

            </div>
          </div>
          
          </div>
        </div>
          
        </div>

        </div>
      </main>
</x-header>
