<?php if (isset($component)) { $__componentOriginal99db13291ff287454d08b974e14dad64f9e2c6f3 = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\Header::class, []); ?>
<?php $component->withName('header'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
    <style>
        /* ====== GLOBAL UI ENHANCEMENTS ====== */
        :root {
            --primary-color: #6366f1;
            --gradient-bg: linear-gradient(135deg, #6366f1, #8b5cf6);
        }

        body {
            background: #f9fafb;
            font-family: 'Inter', sans-serif;
        }

        .glass-panel {
            backdrop-filter: blur(14px);
            background: rgba(255, 255, 255, 0.75);
            border: 1px solid rgba(255, 255, 255, 0.3);
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.05);
            border-radius: 1rem;
            transition: all 0.3s ease;
        }

        .glass-panel:hover {
            transform: translateY(-4px);
            box-shadow: 0 8px 24px rgba(0, 0, 0, 0.08);
        }

        .dashboard-header {
            background: var(--gradient-bg);
            color: #fff;
            border-radius: 1rem;
            box-shadow: 0 10px 25px rgba(99, 102, 241, 0.3);
            padding: 2rem;
        }

        .stat-value {
            font-size: 2rem;
            font-weight: 800;
        }

        .progress-bar {
            height: 8px;
            background: #e5e7eb;
            border-radius: 4px;
            overflow: hidden;
        }

        .progress-inner {
            height: 100%;
            background: var(--primary-color);
            transition: width 1.2s ease;
        }

        /* Button Style */
        .btn-gradient {
            background: var(--gradient-bg);
            color: white;
            font-weight: 600;
            padding: 0.5rem 1.2rem;
            border-radius: 0.5rem;
            transition: all 0.3s ease;
        }

        .btn-gradient:hover {
            box-shadow: 0 4px 15px rgba(99, 102, 241, 0.3);
            transform: translateY(-2px);
        }
    </style>

    <main class="main-content w-full px-[var(--margin-x)] pb-8">

        <!-- Header -->
        <div class="dashboard-header mt-8 animate-fadeIn">
            <div class="flex justify-between items-center">
                <div>
                    <h1 class="text-3xl font-bold">Admin Dashboard</h1>
                    <p class="mt-1 opacity-80">Monitor app performance and activity insights in real-time.</p>
                </div>
                <div>
                    <button class="btn-gradient flex items-center">
                        <i class="fa fa-download mr-2"></i> Export Report
                    </button>
                </div>
            </div>
        </div>

        <!-- Main Stats -->
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6 mt-8">
            <?php $__currentLoopData = [
                ['title' => "Today's Coins", 'value' => $today_earn, 'icon' => 'fa-coins', 'color' => 'text-amber-500'],
                ['title' => 'Total Users', 'value' => $total_user, 'icon' => 'fa-users', 'color' => 'text-blue-500'],
                ['title' => 'Pending Redeems', 'value' => $pending_redeem, 'icon' => 'fa-clock', 'color' => 'text-orange-500'],
                ['title' => 'Paid Redeems', 'value' => $paid_redeem, 'icon' => 'fa-check-circle', 'color' => 'text-green-500'],
            ]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $card): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="glass-panel p-6">
                    <div class="flex justify-between items-center">
                        <div>
                            <p class="text-slate-500 font-medium"><?php echo e($card['title']); ?></p>
                            <p class="stat-value text-slate-800 mt-1"><?php echo e($card['value']); ?></p>
                        </div>
                        <div class="p-3 bg-slate-100 rounded-full <?php echo e($card['color']); ?>">
                            <i class="fa <?php echo e($card['icon']); ?> text-xl"></i>
                        </div>
                    </div>
                    <div class="progress-bar mt-4">
                        <div class="progress-inner" style="width: <?php echo e(rand(50,90)); ?>%"></div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <!-- Charts Section -->
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mt-8">
            <div class="glass-panel p-6">
                <h3 class="font-semibold text-slate-700 mb-4">User Growth</h3>
                <canvas id="growthChart"></canvas>
            </div>
            <div class="glass-panel p-6">
                <h3 class="font-semibold text-slate-700 mb-4">Redeem Trends</h3>
                <canvas id="redeemChart"></canvas>
            </div>
        </div>

        <!-- Top Users -->
        <div class="glass-panel p-6 mt-8">
            <h3 class="font-semibold text-slate-700 mb-4">Top Performers</h3>
            <?php $__currentLoopData = $top_users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="flex items-center justify-between mb-4 border-b border-slate-200 pb-3">
                    <div class="flex items-center">
                        <img src="<?php echo e($user->image ?? '/default.png'); ?>" class="h-10 w-10 rounded-full object-cover">
                        <div class="ml-3">
                            <p class="font-medium text-slate-700"><?php echo e($user->name); ?></p>
                            <p class="text-xs text-slate-400"><?php echo e(number_format($user->point)); ?> Point</p>
                        </div>
                    </div>
                    <span class="bg-indigo-100 text-indigo-600 text-xs font-semibold px-3 py-1 rounded-full">#<?php echo e($index + 1); ?></span>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </main>

    <!-- Add Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        const growthChart = new Chart(document.getElementById('growthChart'), {
            type: 'line',
            data: {
                labels: ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'],
                datasets: [{
                    label: 'Users',
                    data: [12, 19, 13, 25, 22, 30, 45],
                    fill: true,
                    borderColor: '#6366f1',
                    backgroundColor: 'rgba(99,102,241,0.1)',
                    tension: 0.4
                }]
            },
            options: { responsive: true, plugins: { legend: { display: false } } }
        });

        const redeemChart = new Chart(document.getElementById('redeemChart'), {
            type: 'bar',
            data: {
                labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun'],
                datasets: [{
                    label: 'Redeems',
                    data: [35, 45, 28, 60, 75, 90],
                    backgroundColor: '#8b5cf6'
                }]
            },
            options: { responsive: true, plugins: { legend: { display: false } } }
        });
    </script>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal99db13291ff287454d08b974e14dad64f9e2c6f3)): ?>
<?php $component = $__componentOriginal99db13291ff287454d08b974e14dad64f9e2c6f3; ?>
<?php unset($__componentOriginal99db13291ff287454d08b974e14dad64f9e2c6f3); ?>
<?php endif; ?>
<?php /**PATH C:\Users\Md Burhan Uddin\Desktop\Game With Reward\admin\resources\views/admin/dashboard.blade.php ENDPATH**/ ?>