<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Meta tags  -->
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta
      name="viewport"
      content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0"
    />

    <title>Neon Bubble Quest Admin Dashboard</title>
    <link rel="icon" type="image/png" href="images/favicon.png" />

    <!-- CSS Assets -->
    <link rel="stylesheet" href="<?php echo e(url('css/app.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(url('css/style.css')); ?>" />

    <!-- Javascript Assets -->
    <script src="<?php echo e(url('js/app.js')); ?>" defer></script>
    <script src="<?php echo e(url('js/csm-add.js')); ?>" defer></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="<?php echo e(asset('css/custom.css')); ?>" rel="stylesheet">
  
    <!-- Additional CSS for professional UI -->
    <style>
      :root {
        --primary-color: #4f46e5;
        --primary-hover: #4338ca;
        --secondary-color: #0ea5e9;
        --success-color: #10b981;
        --warning-color: #f59e0b;
        --danger-color: #ef4444;
        --dark-color: #1e293b;
        --light-color: #f8fafc;
        --sidebar-width: 280px;
        --header-height: 70px;
        --transition-speed: 0.3s;
      }

      /* Animations */
      @keyframes  fadeIn {
        from { opacity: 0; transform: translateY(10px); }
        to { opacity: 1; transform: translateY(0); }
      }

      @keyframes  slideIn {
        from { transform: translateX(-20px); opacity: 0; }
        to { transform: translateX(0); opacity: 1; }
      }

      .animate-fadeIn {
        animation: fadeIn 0.4s ease-out forwards;
      }

      .animate-slideIn {
        animation: slideIn 0.3s ease-out forwards;
      }

      /* Sidebar Styling */
      .sidebar-panel {
        box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
        transition: transform var(--transition-speed) ease-in-out;
      }

      .sidebar-menu-item {
        border-radius: 0.5rem;
        transition: all var(--transition-speed) ease;
        margin-bottom: 0.25rem;
      }

      .sidebar-menu-item:hover {
        background-color: rgba(79, 70, 229, 0.1);
      }

      .sidebar-menu-item.active {
        background-color: rgba(79, 70, 229, 0.15);
        color: var(--primary-color);
        font-weight: 600;
      }

      .sidebar-menu-icon {
        display: flex;
        align-items: center;
        justify-content: center;
        width: 2rem;
        height: 2rem;
        border-radius: 0.5rem;
        margin-right: 0.75rem;
        transition: all var(--transition-speed) ease;
      }

      .sidebar-menu-item:hover .sidebar-menu-icon {
        background-color: rgba(79, 70, 229, 0.2);
        transform: scale(1.1);
      }

      .sidebar-submenu {
        padding-left: 2.5rem;
        margin-top: 0.25rem;
      }

      .sidebar-submenu-item {
        border-radius: 0.375rem;
        transition: all 0.2s ease;
        padding: 0.5rem 0.75rem;
        margin-bottom: 0.125rem;
      }

      .sidebar-submenu-item:hover {
        background-color: rgba(79, 70, 229, 0.05);
      }

      .sidebar-header {
        position: relative;
        overflow: hidden;
        border-radius: 0 0 1rem 1rem;
      }

      .sidebar-header::after {
        content: '';
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        height: 50%;
        background: linear-gradient(to top, rgba(0,0,0,0.5), transparent);
      }

      .sidebar-profile {
        position: relative;
        z-index: 10;
      }

      .sidebar-profile-avatar {
        border: 3px solid white;
        box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
        transition: transform 0.3s ease;
      }

      .sidebar-profile-avatar:hover {
        transform: scale(1.05);
      }

      .admin-badge {
        display: inline-block;
        padding: 0.25rem 0.75rem;
        border-radius: 9999px;
        font-size: 0.75rem;
        font-weight: 600;
        background: linear-gradient(135deg, #4f46e5, #7e3af2);
        color: white;
        box-shadow: 0 2px 4px rgba(79, 70, 229, 0.3);
      }

      /* Custom scrollbar */
      .custom-scrollbar::-webkit-scrollbar {
        width: 6px;
      }

      .custom-scrollbar::-webkit-scrollbar-track {
        background: #f1f1f1;
        border-radius: 10px;
      }

      .custom-scrollbar::-webkit-scrollbar-thumb {
        background: #c5c5c5;
        border-radius: 10px;
      }

      .custom-scrollbar::-webkit-scrollbar-thumb:hover {
        background: #a8a8a8;
      }
    </style>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Poppins:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet"
    />
  </head>

  <body x-data class="is-header-blur" x-bind="$store.global.documentBody">
    <!-- App preloader-->
    <div
      class="app-preloader fixed z-50 grid h-full w-full place-content-center bg-slate-50 dark:bg-navy-900"
    >
      <div class="flex flex-col items-center">
        <div class="spinner h-12 w-12 animate-spin text-primary">
          <svg
            xmlns="http://www.w3.org/2000/svg"
            class="h-full w-full"
            fill="none"
            viewBox="0 0 28 28"
          >
            <path
              fill="currentColor"
              fill-rule="evenodd"
              d="M28 14c0 7.732-6.268 14-14 14S0 21.732 0 14 6.268 0 14 0s14 6.268 14 14zm-2.764.005c0 6.185-5.014 11.2-11.2 11.2-6.185 0-11.2-5.015-11.2-11.2 0-6.186 5.015-11.2 11.2-11.2 6.186 0 11.2 5.014 11.2 11.2zM8.4 16.8a2.8 2.8 0 100-5.6 2.8 2.8 0 000 5.6z"
              clip-rule="evenodd"
            />
          </svg>
        </div>
        <p class="mt-4 text-lg font-medium text-slate-700">Loading...</p>
      </div>
    </div>


    <!-- Page Wrapper -->
    <div
      id="root"
      class="min-h-100vh flex grow bg-slate-50 dark:bg-navy-900"
      x-cloak
    >
      
    <!-- Top Header -->
    <header class="fixed top-0 left-0 right-0 z-30 flex h-[var(--header-height)] w-full items-center justify-between bg-white px-4 shadow-sm transition-all duration-[var(--transition-speed)] dark:bg-navy-750 print:hidden">
      
 
    </header>
    
    <!-- Adjust main content for fixed header -->
    <style>
      :root {
        --header-height: 70px;
      }
      #root {
     
      }
    </style>

    <!-- Sidebar -->
    <div class="sidebar print:hidden">
        <!-- Main Sidebar -->
        
        <!-- Include the success alert -->
        <?php echo $__env->make('components.success-alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <!-- Sidebar Panel -->
        <div class="sidebar-panel">
          <div
            class="flex h-full grow flex-col bg-white pl-[var(--main-sidebar-width)] dark:bg-navy-750"
          >
            <!-- Sidebar Panel Header -->
            <div class="flex items-center justify-between h-16 px-3 bg-white dark:bg-navy-750 border-b border-slate-150 dark:border-navy-700">
              <div class="flex items-center">
                <div class="flex items-center justify-center w-10 h-10 rounded-lg bg-primary/10">
                  <i class="fa-solid fa-image text-primary text-xl"></i>
                </div>
                <h2 class="ml-3 text-lg font-bold text-slate-700 dark:text-navy-100">Neon Bubble Quest</h2>
              </div>
              <button
                @click="$store.global.isSidebarExpanded = false"
                class="btn h-8 w-8 rounded-full p-0 text-primary hover:bg-slate-300/20 focus:bg-slate-300/20 active:bg-slate-300/25 dark:text-accent-light/80 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25 xl:hidden"
              >
                <svg
                  xmlns="http://www.w3.org/2000/svg"
                  class="h-5 w-5"
                  fill="none"
                  viewBox="0 0 24 24"
                  stroke="currentColor"
                >
                  <path
                    stroke-linecap="round"
                    stroke-linejoin="round"
                    stroke-width="2"
                    d="M15 19l-7-7 7-7"
                  />
                </svg>
              </button>
            </div>
            <style>
            .pl-\[var\(--main-sidebar-width\)\] {
            padding-left: 0rem !important;
            }
            :root {
            --main-sidebar-width: 0rem !important;
            --sidebar-panel-width: 290px;
            }
            </style>
            <!-- Sidebar Panel Body -->
            <div class="flex h-full w-full transform-gpu flex-col bg-white transition-transform duration-200 dark:bg-navy-750 custom-scrollbar" style="overflow-y:auto;"
            x-transition:enter="ease-out" x-transition:enter-start="-translate-x-full" x-transition:enter-end="translate-x-0" x-transition:leave="ease-in" x-transition:leave-start="translate-x-0" x-transition:leave-end="-translate-x-full">
                <!-- Sidebar Header with Profile -->
                <div class="sidebar-header h-40 relative">
                  <img class="h-full w-full object-cover object-center" src="<?php echo e(url('/images/images2.jpg')); ?>" alt="background">
                  <div class="absolute inset-0 bg-gradient-to-t from-slate-900/70 to-slate-900/20"></div>
                </div>
                
                <div class="sidebar-profile flex px-5 -mt-10 relative z-10">
                  <div class="sidebar-profile-avatar h-20 w-20">
                    <img class="rounded-full border-3 border-white shadow-lg dark:border-navy-700" src="<?php echo e(url('/images/favicon.png')); ?>" alt="avatar">
                  </div>
                  <div class="mt-3 ml-3 flex flex-col">
                    <h4 class="text-base font-semibold text-white dark:text-navy-50">
                      Admin Dashboard
                    </h4>
                    <div class="mt-1.5">
                      <span class="admin-badge">
                        <i class="fa-solid fa-shield-halved mr-1"></i>
                        Administrator
                      </span>
                    </div>
                  </div>
                </div>
                
                <div class="my-4 mx-5 h-px bg-slate-200 dark:bg-navy-500"></div>

                <!-- Sidebar Menu -->
                <ul class="flex flex-1 flex-col px-4 font-medium space-y-1">
                  <!-- Dashboard -->
                  <li class="sidebar-menu-item active animate-slideIn" style="animation-delay: 0.1s">
                    <a href="<?php echo e(route('admin.dashboard')); ?>" class="flex items-center px-4 py-3 text-slate-700 dark:text-navy-100">
                      <div class="sidebar-menu-icon bg-primary/10 text-primary">
                        <i class="fa-solid fa-gauge-high"></i>
                      </div>
                      <span>Dashboard</span>
                    </a>
                  </li>

                  <!-- Users Menu -->
                  <li x-data="accordionItem('menu-item-1')" class="animate-slideIn" style="animation-delay: 0.2s">
                    <a :class="expanded && 'text-primary font-semibold dark:text-navy-50'"
                      @click="expanded = !expanded"
                      class="sidebar-menu-item flex items-center justify-between px-4 py-3 text-slate-700 dark:text-navy-100 cursor-pointer"
                    >
                      <div class="flex items-center">
                        <div class="sidebar-menu-icon bg-blue-100 text-blue-600 dark:bg-blue-900/20 dark:text-blue-400">
                          <i class="fa-solid fa-users"></i>
                        </div>
                        <span>Users</span>
                      </div>
                      <svg
                        :class="expanded && 'rotate-90'"
                        xmlns="http://www.w3.org/2000/svg"
                        class="h-5 w-5 text-slate-400 transition-transform ease-in-out"
                        fill="none"
                        viewbox="0 0 24 24"
                        stroke="currentColor"
                      >
                        <path
                          stroke-linecap="round"
                          stroke-linejoin="round"
                          stroke-width="2"
                          d="M9 5l7 7-7 7"
                        />
                      </svg>
                    </a>
                    <ul x-collapse x-show="expanded" class="sidebar-submenu mt-1">
                      <li>
                        <a
                          href="<?php echo e(route('admin.users')); ?>"
                          class="sidebar-submenu-item flex items-center text-slate-600 dark:text-navy-200"
                        >
                          <i class="fa-solid fa-user-group mr-2 text-xs"></i>
                          <span>User List</span>
                        </a>
                      </li>

                      <li>
                        <a href="<?php echo e(route('admin.tracking')); ?>"
                          class="sidebar-submenu-item flex items-center text-slate-600 dark:text-navy-200"
                        >
                          <i class="fa-solid fa-location-dot mr-2 text-xs"></i>
                          <span>User Tracker</span>
                        </a>
                      </li>
                    </ul>
                  </li>
                  
                  <!-- Rewards Menu -->
                  <li x-data="accordionItem('menu-item-2')" class="animate-slideIn" style="animation-delay: 0.3s">
                    <a :class="expanded && 'text-primary font-semibold dark:text-navy-50'"
                      @click="expanded = !expanded"
                      class="sidebar-menu-item flex items-center justify-between px-4 py-3 text-slate-700 dark:text-navy-100 cursor-pointer"
                    >
                      <div class="flex items-center">
                        <div class="sidebar-menu-icon bg-amber-100 text-amber-600 dark:bg-amber-900/20 dark:text-amber-400">
                          <i class="fa-solid fa-gift"></i>
                        </div>
                        <span>Rewards</span>
                      </div>
                      <svg
                        :class="expanded && 'rotate-90'"
                        xmlns="http://www.w3.org/2000/svg"
                        class="h-5 w-5 text-slate-400 transition-transform ease-in-out"
                        fill="none"
                        viewbox="0 0 24 24"
                        stroke="currentColor"
                      >
                        <path
                          stroke-linecap="round"
                          stroke-linejoin="round"
                          stroke-width="2"
                          d="M9 5l7 7-7 7"
                        />
                      </svg>
                    </a>
                    <ul x-collapse x-show="expanded" class="sidebar-submenu mt-1">
                      <li>
                        <a
                          href="#"
                          class="sidebar-submenu-item flex items-center text-slate-600 dark:text-navy-200"
                        >
                          <i class="fa-solid fa-coins mr-2 text-xs"></i>
                          <span>Manage Coins</span>
                        </a>
                      </li>
                      <li>
                        <a
                          href="#"
                          class="sidebar-submenu-item flex items-center text-slate-600 dark:text-navy-200"
                        >
                          <i class="fa-solid fa-hand-holding-dollar mr-2 text-xs"></i>
                          <span>Redemptions</span>
                        </a>
                      </li>
                    </ul>
                  </li>
                  



 
                  <li x-data="accordionItem('menu-item-3')" class="animate-slideIn" style="animation-delay: 0.4s">
                    <a  href="<?php echo e(route('admin.app_config')); ?>" :class="expanded && 'text-primary font-semibold dark:text-navy-50'"
                      @click="expanded = !expanded"
                      class="sidebar-menu-item flex items-center justify-between px-4 py-3 text-slate-700 dark:text-navy-100 cursor-pointer"
                    >
                      <div class="flex items-center">
                        <div class="sidebar-menu-icon bg-green-100 text-green-600 dark:bg-green-900/20 dark:text-green-400">
                               <i class="fa-solid fa-gear" style="margin-right:3px;"></i>
                        </div>
                        <span>App Config Settings</span>
                      </div>
                     <svg
                        :class="expanded && 'rotate-90'"
                        xmlns="http://www.w3.org/2000/svg"
                        class="h-5 w-5 text-slate-400 transition-transform ease-in-out"
                        fill="none"
                        viewbox="0 0 24 24"
                        stroke="currentColor"
                      >
                        <path
                          stroke-linecap="round"
                          stroke-linejoin="round"
                          stroke-width="2"
                          d="M9 5l7 7-7 7"
                        />
                      </svg>
                    </a>
                     
                  </li>



                <li x-data="accordionItem('menu-item-3')" class="animate-slideIn" style="animation-delay: 0.4s">
                    <a  href="<?php echo e(route('admin.refer_config')); ?>" :class="expanded && 'text-primary font-semibold dark:text-navy-50'"
                      @click="expanded = !expanded"
                      class="sidebar-menu-item flex items-center justify-between px-4 py-3 text-slate-700 dark:text-navy-100 cursor-pointer"
                    >
                      <div class="flex items-center">
                        <div class="sidebar-menu-icon bg-green-100 text-green-600 dark:bg-green-900/20 dark:text-green-400">
                               <i class="fa-solid fa-gear" style="margin-right:3px;"></i>
                        </div>
                        <span>Refer Config Settings</span>
                      </div>
                     <svg
                        :class="expanded && 'rotate-90'"
                        xmlns="http://www.w3.org/2000/svg"
                        class="h-5 w-5 text-slate-400 transition-transform ease-in-out"
                        fill="none"
                        viewbox="0 0 24 24"
                        stroke="currentColor"
                      >
                        <path
                          stroke-linecap="round"
                          stroke-linejoin="round"
                          stroke-width="2"
                          d="M9 5l7 7-7 7"
                        />
                      </svg>
                    </a>
                     
                  </li>

      

       
                <li x-data="accordionItem('menu-item-3')" class="animate-slideIn" style="animation-delay: 0.4s">
                    <a  href="<?php echo e(route('admin.game_settings')); ?>" :class="expanded && 'text-primary font-semibold dark:text-navy-50'"
                      @click="expanded = !expanded"
                      class="sidebar-menu-item flex items-center justify-between px-4 py-3 text-slate-700 dark:text-navy-100 cursor-pointer"
                    >
                      <div class="flex items-center">
                        <div class="sidebar-menu-icon bg-green-100 text-green-600 dark:bg-green-900/20 dark:text-green-400">
                               <i class="fa-solid fa-gear" style="margin-right:3px;"></i>
                        </div>
                        <span>Game Settings</span>
                      </div>
                     <svg
                        :class="expanded && 'rotate-90'"
                        xmlns="http://www.w3.org/2000/svg"
                        class="h-5 w-5 text-slate-400 transition-transform ease-in-out"
                        fill="none"
                        viewbox="0 0 24 24"
                        stroke="currentColor"
                      >
                        <path
                          stroke-linecap="round"
                          stroke-linejoin="round"
                          stroke-width="2"
                          d="M9 5l7 7-7 7"
                        />
                      </svg>
                    </a>
                     
                  </li>

      

             
       
                <li x-data="accordionItem('menu-item-3')" class="animate-slideIn" style="animation-delay: 0.4s">
                    <a  href="<?php echo e(route('admin.survey_offersettings')); ?>" :class="expanded && 'text-primary font-semibold dark:text-navy-50'"
                      @click="expanded = !expanded"
                      class="sidebar-menu-item flex items-center justify-between px-4 py-3 text-slate-700 dark:text-navy-100 cursor-pointer"
                    >
                      <div class="flex items-center">
                        <div class="sidebar-menu-icon bg-green-100 text-green-600 dark:bg-green-900/20 dark:text-green-400">
                               <i class="fa-solid fa-gear" style="margin-right:3px;"></i>
                        </div>
                        <span>Survey and offerWall Settings</span>
                      </div>
                     <svg
                        :class="expanded && 'rotate-90'"
                        xmlns="http://www.w3.org/2000/svg"
                        class="h-5 w-5 text-slate-400 transition-transform ease-in-out"
                        fill="none"
                        viewbox="0 0 24 24"
                        stroke="currentColor"
                      >
                        <path
                          stroke-linecap="round"
                          stroke-linejoin="round"
                          stroke-width="2"
                          d="M9 5l7 7-7 7"
                        />
                      </svg>
                    </a>
                     
                  </li>

      
           
              
                <li x-data="accordionItem('menu-item-3')" class="animate-slideIn" style="animation-delay: 0.4s">
                    <a  href="<?php echo e(route('admin.admin_settings')); ?>" :class="expanded && 'text-primary font-semibold dark:text-navy-50'"
                      @click="expanded = !expanded"
                      class="sidebar-menu-item flex items-center justify-between px-4 py-3 text-slate-700 dark:text-navy-100 cursor-pointer"
                    >
                      <div class="flex items-center">
                        <div class="sidebar-menu-icon bg-green-100 text-green-600 dark:bg-green-900/20 dark:text-green-400">
                               <i class="fa-solid fa-gear" style="margin-right:3px;"></i>
                        </div>
                        <span>Admin Settings</span>
                      </div>
                     <svg
                        :class="expanded && 'rotate-90'"
                        xmlns="http://www.w3.org/2000/svg"
                        class="h-5 w-5 text-slate-400 transition-transform ease-in-out"
                        fill="none"
                        viewbox="0 0 24 24"
                        stroke="currentColor"
                      >
                        <path
                          stroke-linecap="round"
                          stroke-linejoin="round"
                          stroke-width="2"
                          d="M9 5l7 7-7 7"
                        />
                      </svg>
                    </a>
                     
                  </li>

      
                  
          
      
           
              
                <li x-data="accordionItem('menu-item-3')" class="animate-slideIn" style="animation-delay: 0.4s">
                    <a  href="<?php echo e(route('admin.fraud_prevention')); ?>" :class="expanded && 'text-primary font-semibold dark:text-navy-50'"
                      @click="expanded = !expanded"
                      class="sidebar-menu-item flex items-center justify-between px-4 py-3 text-slate-700 dark:text-navy-100 cursor-pointer"
                    >
                      <div class="flex items-center">
                        <div class="sidebar-menu-icon bg-green-100 text-green-600 dark:bg-green-900/20 dark:text-green-400">
                               <i class="fa-solid fa-gear" style="margin-right:3px;"></i>
                        </div>
                        <span>Fraud Prevention</span>
                      </div>
                     <svg
                        :class="expanded && 'rotate-90'"
                        xmlns="http://www.w3.org/2000/svg"
                        class="h-5 w-5 text-slate-400 transition-transform ease-in-out"
                        fill="none"
                        viewbox="0 0 24 24"
                        stroke="currentColor"
                      >
                        <path
                          stroke-linecap="round"
                          stroke-linejoin="round"
                          stroke-width="2"
                          d="M9 5l7 7-7 7"
                        />
                      </svg>
                    </a>
                     
                  </li>

      


                  
           
              
                <li x-data="accordionItem('menu-item-3')" class="animate-slideIn" style="animation-delay: 0.4s">
                    <a  href="<?php echo e(route('admin.all_page')); ?>" :class="expanded && 'text-primary font-semibold dark:text-navy-50'"
                      @click="expanded = !expanded"
                      class="sidebar-menu-item flex items-center justify-between px-4 py-3 text-slate-700 dark:text-navy-100 cursor-pointer"
                    >
                      <div class="flex items-center">
                        <div class="sidebar-menu-icon bg-green-100 text-green-600 dark:bg-green-900/20 dark:text-green-400">
                               <i class="fa-solid fa-gear" style="margin-right:3px;"></i>
                        </div>
                        <span>Page</span>
                      </div>
                     <svg
                        :class="expanded && 'rotate-90'"
                        xmlns="http://www.w3.org/2000/svg"
                        class="h-5 w-5 text-slate-400 transition-transform ease-in-out"
                        fill="none"
                        viewbox="0 0 24 24"
                        stroke="currentColor"
                      >
                        <path
                          stroke-linecap="round"
                          stroke-linejoin="round"
                          stroke-width="2"
                          d="M9 5l7 7-7 7"
                        />
                      </svg>
                    </a>
                     
                  </li>

                  
           
              
                <li x-data="accordionItem('menu-item-3')" class="animate-slideIn" style="animation-delay: 0.4s">
                    <a  href="<?php echo e(route('admin.ad_unit')); ?>" :class="expanded && 'text-primary font-semibold dark:text-navy-50'"
                      @click="expanded = !expanded"
                      class="sidebar-menu-item flex items-center justify-between px-4 py-3 text-slate-700 dark:text-navy-100 cursor-pointer"
                    >
                      <div class="flex items-center">
                        <div class="sidebar-menu-icon bg-green-100 text-green-600 dark:bg-green-900/20 dark:text-green-400">
                               <i class="fa-solid fa-gear" style="margin-right:3px;"></i>
                        </div>
                        <span>Adnetworks Ad Unit</span>
                      </div>
                     <svg
                        :class="expanded && 'rotate-90'"
                        xmlns="http://www.w3.org/2000/svg"
                        class="h-5 w-5 text-slate-400 transition-transform ease-in-out"
                        fill="none"
                        viewbox="0 0 24 24"
                        stroke="currentColor"
                      >
                        <path
                          stroke-linecap="round"
                          stroke-linejoin="round"
                          stroke-width="2"
                          d="M9 5l7 7-7 7"
                        />
                      </svg>
                    </a>
                     
                  </li>


                  <!-- Payment Menu -->
                  <li x-data="accordionItem('menu-item-35344')" class="animate-slideIn" style="animation-delay: 0.4s">
                    <a :class="expanded && 'text-primary font-semibold dark:text-navy-50'"
                      @click="expanded = !expanded"
                      class="sidebar-menu-item flex items-center justify-between px-4 py-3 text-slate-700 dark:text-navy-100 cursor-pointer"
                    >
                      <div class="flex items-center">
                        <div class="sidebar-menu-icon bg-green-100 text-green-600 dark:bg-green-900/20 dark:text-green-400">
                                   <i class="fa-solid fa-list-check"></i>
                        </div>
                        <span> Payment </span>
                      </div>
                      <svg
                        :class="expanded && 'rotate-90'"
                        xmlns="http://www.w3.org/2000/svg"
                        class="h-5 w-5 text-slate-400 transition-transform ease-in-out"
                        fill="none"
                        viewbox="0 0 24 24"
                        stroke="currentColor"
                      >
                        <path
                          stroke-linecap="round"
                          stroke-linejoin="round"
                          stroke-width="2"
                          d="M9 5l7 7-7 7"
                        />
                      </svg>
                    </a>
                    <ul x-collapse x-show="expanded" class="sidebar-submenu mt-1">
                    
                         
      
                            <li>
                              <a href="<?php echo e(route('admin.payment_methodlist')); ?>"
                                class="flex items-center justify-between p-2 text-xs+ tracking-wide text-slate-500 outline-none transition-[color,padding-left] duration-300 ease-in-out hover:pl-4 hover:text-slate-800 dark:text-navy-200 dark:hover:text-navy-50">
                                <div class="flex items-center space-x-2">
                                  <div
                                    class="h-1.5 w-1.5 rounded-full border border-current opacity-40"
                                  ></div>
                                  <span>Payment Method List</span>
                                </div>
                              </a>
                            </li>    


                            
      
                            <li>
                              <a href="<?php echo e(route('admin.payment_request')); ?>"
                                class="flex items-center justify-between p-2 text-xs+ tracking-wide text-slate-500 outline-none transition-[color,padding-left] duration-300 ease-in-out hover:pl-4 hover:text-slate-800 dark:text-navy-200 dark:hover:text-navy-50">
                                <div class="flex items-center space-x-2">
                                  <div
                                    class="h-1.5 w-1.5 rounded-full border border-current opacity-40"
                                  ></div>
                                  <span>Payment Request List</span>
                                </div>
                              </a>
                            </li>  

                      
                    </ul>
                  </li>


 
                  <li x-data="accordionItem('menu-item-3444343')" class="animate-slideIn" style="animation-delay: 0.4s">
                    <a :class="expanded && 'text-primary font-semibold dark:text-navy-50'"
                      @click="expanded = !expanded"
                      class="sidebar-menu-item flex items-center justify-between px-4 py-3 text-slate-700 dark:text-navy-100 cursor-pointer"
                    >
                      <div class="flex items-center">
                        <div class="sidebar-menu-icon bg-green-100 text-green-600 dark:bg-green-900/20 dark:text-green-400">
                                   <i class="fa-solid fa-list-check"></i>
                        </div>
                        <span> Notification </span>
                      </div>
                      <svg
                        :class="expanded && 'rotate-90'"
                        xmlns="http://www.w3.org/2000/svg"
                        class="h-5 w-5 text-slate-400 transition-transform ease-in-out"
                        fill="none"
                        viewbox="0 0 24 24"
                        stroke="currentColor"
                      >
                        <path
                          stroke-linecap="round"
                          stroke-linejoin="round"
                          stroke-width="2"
                          d="M9 5l7 7-7 7"
                        />
                      </svg>
                    </a>
                    <ul x-collapse x-show="expanded" class="sidebar-submenu mt-1">
                    
                             
                    
                      <li>
                        <a
                          href="<?php echo e(route('admin.send_notification')); ?>"
                          class="flex items-center justify-between p-2 text-xs+ tracking-wide text-slate-500 outline-none transition-[color,padding-left] duration-300 ease-in-out hover:pl-4 hover:text-slate-800 dark:text-navy-200 dark:hover:text-navy-50"
                        >
                          <div class="flex items-center space-x-2">
                            <div
                              class="h-1.5 w-1.5 rounded-full border border-current opacity-40"
                            ></div>
                            <span>Add Notification</span>
                          </div>
                        </a>
                      </li>


                      <li>
                        <a
                            href="<?php echo e(route('admin.all_notification')); ?>"
                          class="flex items-center justify-between p-2 text-xs+ tracking-wide text-slate-500 outline-none transition-[color,padding-left] duration-300 ease-in-out hover:pl-4 hover:text-slate-800 dark:text-navy-200 dark:hover:text-navy-50"
                        >
                          <div class="flex items-center space-x-2">
                            <div
                              class="h-1.5 w-1.5 rounded-full border border-current opacity-40"
                            ></div>
                            <span>Notification List</span>
                          </div>
                        </a>
                      </li>
                      
                    </ul>
                  </li>

            
       


                    </ul>

                <div class="p-5">

                  <form method="POST" action="<?php echo e(route('admin.logout')); ?>" x-data>
                    <?php echo csrf_field(); ?>
                      <button type="submit" name="logout" class="btn mt-2 w-full space-x-2 bg-error/10 font-medium text-error hover:bg-error/20 focus:bg-error/20 active:bg-error/25">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"></path>
                        </svg>
                        <span>Logout</span>
                      </button>
                    </form>
                </div>
              </div>

          </div>
        </div>
        <div class=""
        @click="$store.global.isSidebarExpanded = false"
        :class="$store.global.isSidebarExpanded && 's-off'"
        >
      </div>
      </div>

      <!-- App Header Wrapper-->
      <nav class="header print:hidden">
        <!-- App Header  -->
        <div
          class="header-container relative flex w-full bg-white dark:bg-navy-750 print:hidden"
        >
          <!-- Header Items -->
          <div class="flex w-full items-center justify-between">
            <!-- Left: Sidebar Toggle Button -->
            <div class="navp">
                <div class="h-7 w-7" id="menu_bar">
                  <button
                    class="menu-toggle ml-0.5 flex h-7 w-7 flex-col justify-center space-y-1.5 text-primary outline-none focus:outline-none dark:text-accent-light/80"
                    :class="$store.global.isSidebarExpanded && 'active'"
                    @click="$store.global.isSidebarExpanded = !$store.global.isSidebarExpanded"
                  >
                    <span></span>
                    <span></span>
                    <span></span>
                  </button>
                </div>

                <a class="logo" href="<?php echo e(url('/')); ?>">
                    <img style="height: 25px;" src=" " alt="">
                </a>
                  </div>

            <!-- Right: Header buttons -->
            <div class="-mr-1.5 flex items-center space-x-1">
              <!-- Mobile Search Toggle -->


              <!-- Main Searchbar -->
              <template x-if="$store.breakpoints.smAndUp">

              </template>

              <!-- Dark Mode Toggle -->
              <button
                @click="$store.global.isDarkModeEnabled = !$store.global.isDarkModeEnabled"
                class="btn h-8 w-8 rounded-full p-0 hover:bg-slate-300/20 focus:bg-slate-300/20 active:bg-slate-300/25 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25"
              >
                <svg
                  x-show="$store.global.isDarkModeEnabled"
                  x-transition:enter="transition-transform duration-200 ease-out absolute origin-top"
                  x-transition:enter-start="scale-75"
                  x-transition:enter-end="scale-100 static"
                  class="h-6 w-6 text-amber-400"
                  fill="currentColor"
                  viewbox="0 0 24 24"
                >
                  <path
                    d="M11.75 3.412a.818.818 0 01-.07.917 6.332 6.332 0 00-1.4 3.971c0 3.564 2.98 6.494 6.706 6.494a6.86 6.86 0 002.856-.617.818.818 0 011.1 1.047C19.593 18.614 16.218 21 12.283 21 7.18 21 3 16.973 3 11.956c0-4.563 3.46-8.31 7.925-8.948a.818.818 0 01.826.404z"
                  />
                </svg>
                <svg
                  xmlns="http://www.w3.org/2000/svg"
                  x-show="!$store.global.isDarkModeEnabled"
                  x-transition:enter="transition-transform duration-200 ease-out absolute origin-top"
                  x-transition:enter-start="scale-75"
                  x-transition:enter-end="scale-100 static"
                  class="h-6 w-6 text-amber-400"
                  viewbox="0 0 20 20"
                  fill="currentColor"
                >
                  <path
                    fill-rule="evenodd"
                    d="M10 2a1 1 0 011 1v1a1 1 0 11-2 0V3a1 1 0 011-1zm4 8a4 4 0 11-8 0 4 4 0 018 0zm-.464 4.95l.707.707a1 1 0 001.414-1.414l-.707-.707a1 1 0 00-1.414 1.414zm2.12-10.607a1 1 0 010 1.414l-.706.707a1 1 0 11-1.414-1.414l.707-.707a1 1 0 011.414 0zM17 11a1 1 0 100-2h-1a1 1 0 100 2h1zm-7 4a1 1 0 011 1v1a1 1 0 11-2 0v-1a1 1 0 011-1zM5.05 6.464A1 1 0 106.465 5.05l-.708-.707a1 1 0 00-1.414 1.414l.707.707zm1.414 8.486l-.707.707a1 1 0 01-1.414-1.414l.707-.707a1 1 0 011.414 1.414zM4 11a1 1 0 100-2H3a1 1 0 000 2h1z"
                    clip-rule="evenodd"
                  />
                </svg>
              </button>

            </div>
          </div>
        </div>
      </nav>

      <?php echo e($slot); ?>



    </div>
    <div id="x-teleport-target"></div>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
    </script>
  </body>
</html>

<?php /**PATH C:\Users\Md Burhan Uddin\Desktop\Game With Reward\admin\resources\views/components/header.blade.php ENDPATH**/ ?>