<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Http\Request;
use App\Models\Admin;
use App\Models\AppUser;
use App\Models\AUser;
use App\Models\DB_Amount;
use App\Models\DB_Game;
use App\Models\DB_Notification;
use App\Models\DB_Payment;
use App\Models\DB_PyRequest;
use App\Models\DB_QuickBonu;
use App\Models\DB_ReadArticle;
use App\Models\DB_Settings;
use App\Models\DB_Tracking;
use App\Models\DB_WallCategory;
use App\Models\DB_Wallpaper;
use App\Models\ModelsDBanner;
use App\Models\Tv_Notification;
use App\Models\Tv_PacakgeRequest;
use App\Models\Tv_Package;
use App\Models\Tv_Redeem;
use App\Models\Tv_RedeemRequest;
use App\Models\Tv_Settings;
use App\Models\Tv_Support;
use App\Models\Tv_Tracking;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;

class HomeController extends Controller
{


    public function adminadd()
    {

 
        $admin = Admin::create([
            'email' => 'admin@example.com',
            'name' => 'Admin',
            'password' => Hash::make('123456'), // hash password
        ]);

        return response()->json([
            'success' => true,
            'message' => 'Admin added successfully',
            'admin' => $admin
        ]);

    }

    public function index()
    {

        $today_date = date('Y-m-d');    
        $today_earn = DB::table('db_tracking')
            ->whereDate('created_at', Carbon::today())
            ->sum('reward');
        $total_point = DB::table('db_tracking')
                ->sum('reward');
        $today_user = DB::table('auser')
            ->whereDate('created_at', Carbon::today())
            ->count(); 
        $all_user = DB::table('auser')
            ->count(); 
        $today_redeem = DB::table('py_request')
            ->whereDate('created_at', Carbon::today())
            ->count(); 
        $all_redeem = DB::table('py_request')
            ->whereDate('created_at', Carbon::today())
            ->count(); 
        $p_r = DB::table('py_request')
            ->whereDate('created_at', Carbon::today())
            ->where('status', '1')
            ->count(); 
        $p_r = DB::table('py_request')
            ->whereDate('created_at', Carbon::today())
            ->where('status', '1')
            ->count(); 
        $paid = DB::table('py_request')
            ->whereDate('created_at', Carbon::today())
            ->where('status', '2')
            ->count(); 
        $top_users = DB::table('auser')
                ->select('name', 'point', 'image')
                ->orderByDesc('point')
                ->take(5)
                ->get();


        $formatted_points = $this->formatNumberShort($total_point);
        $formatted_today_points = $this->formatNumberShort($today_earn);
        $formatted_today_user = $this->formatNumberShort($today_user);
        $formatted_all_user = $this->formatNumberShort($all_user);
        $formatted_today_redeem = $this->formatNumberShort($today_redeem);
        $formatted_total_redeem = $this->formatNumberShort($all_redeem);
        $pending_redeem = $this->formatNumberShort($p_r);
        $paid_redeem = $this->formatNumberShort($paid);

        return view('admin.dashboard',[
            'today_earn' => $formatted_today_points,
            'total_point' => $formatted_points,
            'total_user' => $formatted_all_user,
            'today_user' => $formatted_today_user,
            'tody_redeem' => $formatted_today_redeem, 
            'total_redem' => $formatted_total_redeem,
            'pending_redeem' => $pending_redeem,
            'paid_redeem' => $paid_redeem,
            'top_users' => $top_users,
            ]);

    }
    

    public function login()
    {
        $admin = Admin::where('id',1)->first();

        return view('admin.auth.login',['admin' => $admin]);
    }


    //new all code **********************************************************************
 
    public function add_wallpaper_category()
    {
        return view('admin.wallpaper_category.add');
    }

    public function add_wallcatred(Request $rq)
    {
   
        $category = new DB_WallCategory();
        if ($rq->hasFile('image')) {
            $file = $rq->file('image');
            $extension = $file->getClientOriginalExtension();
            $filename = time() . '_' . uniqid() . '.' . $extension;
            $path = 'images/upload/wallpaper_category';
            $file->move($path, $filename);
        }
        $category->title = $rq['title'];
        $category->home_page = $rq['home_page'] ?? '0';
        $category->image = $filename;
        $category->save();
        // Add a success message to session
        return redirect()->back()->with('success', 'Wallpaper category added successfully!');
            
    }

    public function wallpapers_category(Request $request)
    {
       $category = DB_WallCategory::latest()->paginate(15);
       return view('admin.wallpaper_category.category', ['category'=>$category]);
    }


    public function delete_wallcat($id)
    {
        DB_WallCategory::find($id)->delete();
        return redirect()->back()->with('success', 'Wallpaper category deleted successfully!');
    }

    //wallpaper
    public function add_wallpaper()
    {
        $categories = DB_WallCategory::where('status', 1)
            ->orderBy('created_at', 'desc')
            ->get(['id', 'title']); // fetch only id and title
        return view('admin.wallpaper.add', compact('categories'));

    }


    public function add_wallpaperreq(Request $rq)
    {

        $wallpaper = new DB_Wallpaper();
        if ($rq->hasFile('image')) {
            $file = $rq->file('image');
            $extension = $file->getClientOriginalExtension();
            $filename = time() . '_' . uniqid() . '.' . $extension;
            $path = 'images/upload/wallpaper';
            $file->move($path, $filename);
        }
        $wallpaper->title = $rq['title'] ?? '';
        $wallpaper->image = $filename;
        $wallpaper->wallpaper_tag = $rq['wallpaper_tag'] ?? '';
        $wallpaper->category_id = $rq['category_id'] ?? null;
        $wallpaper->save();
        // Add a success message to session
        return redirect()->back()->with('success', 'Wallpaper added successfully!');
       

    }

    public function wallpaper_configreq(Request $request)
    {

        $setting = DB_Settings::find(1);
        $newData = [
            'cap_greqpoint' => $request->input('cap_greqpoint'),
            'fallback_1' => $request->input('fallback_1'),
            'fallback_2' => $request->input('fallback_2'),
            'ai_apikey' => $request->input('ai_apikey'),
            'ai_model' => $request->input('ai_model'),
        ];

        $setting->aicaption_config = json_encode($newData);
        $setting->save();
    
        // Add a success message to session
        return redirect()->back()->with('success', 'Ai Caption Settings added successfully!');
    
   

    }

   public function ai_captionsettting(){
        $setting = DB_Settings::where('id',1)->first();
        return view('admin.add_setting.ai_captionsettting', ['settings'=>$setting]);
    }

    public function daily_reward(){
        $setting = DB_Settings::where('id',1)->first();
        return view('admin.add_setting.daily_setting', ['settings'=>$setting]);
    }

    public function daily_rewardreq(Request $request)
    {

        $setting = DB_Settings::find(1);
        $newData = [
            'day1_reward' => $request->input('day1_reward'),
            'day2_reward' => $request->input('day2_reward'),
            'day3_reward' => $request->input('day3_reward'),
            'day4_reward' => $request->input('day4_reward'),
            'day5_reward' => $request->input('day5_reward'),
            'day6_reward' => $request->input('day6_reward'),
            'day7_reward' => $request->input('day7_reward'),
            'fallback_1' => $request->input('fallback_1'),
            'fallback_2' => $request->input('fallback_2'),
        ];

        $setting->daily_config = json_encode($newData);
        $setting->save();
        return redirect()->back()->with('success', 'Daily Reward Settings added successfully!');


    }

    public function survey_offersettings(){
        $setting = DB_Settings::where('id',1)->first();
        return view('admin.add_setting.survey_offer', ['settings'=>$setting]);
    }

    

    public function update_surveyandofffer(Request $request)
    {
 
        $setting = DB_Settings::find(1);
        $newData = [
            'pubscale_appid' => $request->input('pubscale_appid'),
            'play_timeadsappid' => $request->input('play_timeadsappid'),
            'tapjoy_skdkey' => $request->input('tapjoy_skdkey'),
            'tapjoy_placementName' => $request->input('tapjoy_placementName'),
            'bitlabs_token' => $request->input('bitlabs_token'),
            'bitlabs_token' => $request->input('bitlabs_token'),
            'cpx_appid' => $request->input('cpx_appid'),
            'timewall_appid' => $request->input('timewall_appid'),
            'wanndsads_apikey' => $request->input('wanndsads_apikey'),
            'monlix_appid' => $request->input('monlix_appid'), 
            'offerwallmedia_apikey' => $request->input('offerwallmedia_apikey'), 
            
        ];
        $setting->offer_survey = json_encode($newData);
        $setting->save();
        return redirect()->back()->with('success', 'OfferWall Settings added successfully!');


    }

    
    public function add_quickbonus()
    {
       return view('admin.quick_bonus.add');
    }


    public function add_quickbonusreq(Request $rq)
    {

        $category = new DB_QuickBonu();
        $category->quickb_title = $rq['quickb_title'];
        $category->quickb_reward = $rq['quickb_reward'];
        $category->quickb_url = $rq['quickb_url'];
        $category->quickb_play_time = $rq['quickb_play_time'];
        $category->quickb_time_option = $rq['quickb_time_option'];
        $category->save();
        return redirect()->back()->with('success', 'Quick Bonus added successfully!');
        
    }
        
        
    public function quick_bonus(){
            $setting = DB_Settings::where('id',1)->first();
            return view('admin.add_setting.quick_bonus', ['settings'=>$setting]);
    }


    public function quick_bonusup(Request $rq)
    {

        $setting = DB_Settings::find(1);
        $newData = [
            'daily_limit' => $rq->input('daily_limit'),
            'fallback_1' => $rq->input('fallback_1'),
            'fallback_2' => $rq->input('fallback_2'),    
        ];
        $setting->quick_bonus = json_encode($newData);
        $setting->save();
        return redirect()->back()->with('success', 'Quick Bonus Settings Update successfully!');

    }
        
    public function gametask(){
        $setting = DB_Settings::where('id',1)->first();
        return view('admin.add_setting.game_task', ['settings'=>$setting]);
    }


    public function gametask_update(Request $rq)
    {

        $setting = DB_Settings::find(1);
        $newData = [
            'daily_limit' => $rq->input('daily_limit'),
            'fallback_1' => $rq->input('fallback_1'),
            'fallback_2' => $rq->input('fallback_2'),    
        ];
        $setting->game_config = json_encode($newData);
        $setting->save();
        return redirect()->back()->with('success', 'Quick Bonus Settings Update successfully!');

    }


    public function add_game()
    {
       return view('admin.game.add');
    }

    public function add_gamereq(Request $rq)
    {

        $filename = null; // default value
        $wallpaper = new DB_Game();
        if ($rq->hasFile('game_logo')) {
            $file = $rq->file('game_logo');
            $extension = $file->getClientOriginalExtension();
            $filename = time() . '_' . uniqid() . '.' . $extension;
            $path = 'images/upload/game';
            $file->move($path, $filename);
        }
        $wallpaper->game_title = $rq['game_title'] ?? '';
        $wallpaper->game_logo = $filename;
        $wallpaper->game_reward = $rq['game_reward'] ?? '';
        $wallpaper->game_url = $rq['game_url'] ?? null;
        $wallpaper->game_play_time = $rq['game_play_time'] ?? null;
        $wallpaper->game_time_option = $rq['game_time_option'] ?? null;
        $wallpaper->save();
        return redirect()->back()->with('success', 'Wallpaper added successfully!');
       
        
    }


    public function game_list(Request $request)
    {
       $category = DB_Game::latest()->paginate(15);
       return view('admin.game.game', ['category'=>$category]);
    }



    public function delete_game($id)
    {
        DB_Game::find($id)->delete();
        return redirect()->back()->with('success', 'Game Item deleted successfully!');
    }


    public function play_quiz()
    {
        $setting = DB_Settings::where('id',1)->first();
        return view('admin.add_setting.play_quiz', ['settings'=>$setting]);
    }

    public function updateplay_quiz(Request $rq)
    {

        $setting = DB_Settings::find(1);
        $newData = [
            'daily_limit' => $rq->input('daily_limit'),
            'fallback_1' => $rq->input('fallback_1'),
            'fallback_2' => $rq->input('fallback_2'),   
            'win_reward' => $rq->input('win_reward'), 
        ];
        $setting->play_quiz = json_encode($newData);
        $setting->save();
        return redirect()->back()->with('success', 'Play Quiz Settings Update successfully!');

    }
    

    public function reward_vault()
    {
        $setting = DB_Settings::where('id',1)->first();
        return view('admin.add_setting.reward_vault', ['settings'=>$setting]);
    }

    public function update_reward_vault(Request $rq)
    {

        $setting = DB_Settings::find(1);
        $newData = [
            'required_xp' => $rq->input('required_xp'),
            'win_coin' => $rq->input('win_coin'),
            'daily_limit' => $rq->input('daily_limit'),
            'fallback_1' => $rq->input('fallback_1'),
            'fallback_2' => $rq->input('fallback_2'),   
        ];
        $setting->reward_vault = json_encode($newData);
        $setting->save();
        return redirect()->back()->with('success', 'Play Quiz Settings Update successfully!');

    }
    

    public function add_article()
    {
         return view('admin.article.add');
    }


    public function add_articlereq(Request $rq)
    {

        $read = new DB_ReadArticle();
        $read->read_title = $rq['read_title'] ?? '';
        $read->read_reward = $rq['read_reward'] ?? '';
        $read->read_url = $rq['read_url'] ?? null;
        $read->read_play_time = $rq['read_play_time'] ?? null;
        $read->read_time_option = $rq['read_time_option'] ?? null;
        $read->save();
        return redirect()->back()->with('success', 'Read Article added successfully!');
       

    }

    public function article_list(Request $request)
    {
       $category = DB_ReadArticle::latest()->paginate(15);
       return view('admin.article.article', ['category'=>$category]);
    }


    public function delete_ar($id)
    {
        DB_ReadArticle::find($id)->delete();
        return redirect()->back()->with('success', 'Article deleted successfully!');
    }


    public function updatearticle_config(Request $rq)
    {

        $setting = DB_Settings::find(1);
        $newData = [
            'how_itwork' => $rq->input('how_itwork'),
            'daily_limit' => $rq->input('daily_limit'),
            'fallback_1' => $rq->input('fallback_1'),
            'fallback_2' => $rq->input('fallback_2'),   
        ];
        $setting->article_config = json_encode($newData);
        $setting->save();
        return redirect()->back()->with('success', 'Play Quiz Settings Update successfully!');
 
    }

    public function article_config()
    {
        $setting = DB_Settings::where('id',1)->first();
        return view('admin.add_setting.article', ['settings'=>$setting]);
    }

    public function add_payment_method()
    {
        return view('admin.payment.add_payment_method');
    }

   

    public function terms_edit()
    {
        $setting = DB_Settings::where('id',1)->first();
        return view('admin.page.terms_edit', ['pages'=>$setting]);
    }

    public function upterms_edit(Request $rq)
    {
        $settings = DB_Settings::find(1);
        $settings->terms_title =$rq['terms_title'];
        $settings->terms_desc =$rq['terms_desc'];
        $settings->save();
        return view('admin.page.terms_edit', ['pages'=>$settings]);
    }

    
    public function privacy_edit()
    {
        $setting = DB_Settings::where('id',1)->first();
        return view('admin.page.privacy_edit', ['pages'=>$setting]);
    }



    public function upprivacy_edit(Request $rq)
    {
        $settings = DB_Settings::find(1);
        $settings->privacy_title =$rq['privacy_title'];
        $settings->privacy_desc =$rq['privacy_desc'];
        $settings->save();
        return view('admin.page.privacy_edit', ['pages'=>$settings]);

    }

    
    public function terms_conditions()
    {
        $settings = DB_Settings::find(1);
        return view('admin.page.terms_conditions', ['pages'=>$settings]);
    }

    public function privacy_policy()
    {
        $settings = DB_Settings::find(1);
        return view('admin.page.privacy_policy', ['pages'=>$settings]);
    }


    public function app_config()
    {
        $setting = DB_Settings::where('id',1)->first();
        return view('admin.add_setting.app_config', ['settings'=>$setting]);
    }


    public function refer_config()
    {
        $setting = DB_Settings::where('id',1)->first();
        return view('admin.add_setting.refer_config', ['settings'=>$setting]);
    }


    
    public function referconfigupdate(Request $rq)
    {

        $setting = DB_Settings::find(1);
        $newData = [
            'level1_point' => $rq->input('level1_point'),
            'level2_point' => $rq->input('level2_point'),
        ];
        $setting->refer_config = json_encode($newData);
        $setting->save();
        return redirect()->back()->with('success', 'Refer Settings Update successfully!');
 
    }



    public function appconfig_update(Request $rq)
    {

        $setting = DB_Settings::find(1);
        $newData = [
            'signup_bonus' => $rq->input('signup_bonus'),
            'support_email' => $rq->input('support_email'),
            'onesignal_app_id' => $rq->input('onesignal_app_id'),
            'cap_greqpoint' => $rq->input('cap_greqpoint'),
            'ai_apikey' => $rq->input('ai_apikey'),

        ];
        $setting->app_config = json_encode($newData);
        $setting->save();
        return redirect()->back()->with('success', 'Refer Settings Update successfully!');
 
    }

    public function fraud_prevention()
    {
        $setting = DB_Settings::where('id',1)->first();
        return view('admin.fraud_prevention', ['settings'=>$setting]);
    }


    public function upfraud_prevention(Request $rq)
    {

        $setting = DB_Settings::find(1);
        $newData = [
            'one_account' => $rq->input('one_account'),
            'block_vpn' => $rq->input('block_vpn'),
            'block_root' => $rq->input('block_root'),
            'block_devmode' => $rq->input('block_devmode'),
        ];
        $setting->fraud_prevention = json_encode($newData);
        $setting->save();
        return redirect()->back()->with('success', 'Fraud Prevention Settings Update successfully!');
 


        $setting = DB_Settings::where('id',1)->first();
        return view('admin.fraud_prevention', ['setting'=>$setting]);
 
    }
    
    
   public function users(Request $request)
    {
       $users = AUser::latest()->paginate(15);
       return view('admin.users.users', ['users'=>$users]);
    }

    public function edit_user($id)
    {
        // Fetch single user by u_id
        $user_data = AUser::where('u_id', $id)->first();
        if (!$user_data) {
            return redirect()->back()->with('error', 'User not found.');
        }
        return view('admin.users.edit_user', compact('user_data'));
    }



    public function admin_del_user($id)
    {
 
        DB::table('auser')->where('u_id', $id)->delete();
        DB::table('db_tracking')->where('u_id', $id)->delete();
        return redirect(route('admin.users'))->with('status-success', 'User Has Been deleted successfully.');

    }
  

    public function tracking_user($id)
    {
        $userdata = DB_Tracking::where('u_id',$id)->latest()->paginate(20);
        return view('admin.users.tracking',['userdata' => $userdata,'u_id' => $id]);
    }

    
    public function update_user(Request $request, $id)
    {
       $user = AUser::where('u_id', $id)->first();
       $user->name = $request['name'];
       $user->point =$request['point'];
       $user->status =$request['status'];
       $user->save();
       return redirect(route('admin.useredit', ['id' => $id]))->with('status-success', 'User Has Been updated');
    }
    
    public function app_status_user($id,$id2)
    {
    
        $user = AUser::where('id', $id)->first();
        $user->status = $id2;
        $user->save();
        return redirect(route('admin.users', ['id' => $id]))->with('status-success', 'Status Has Been updated');

    }

    
    public function tracking(Request $request)
    {

        $user = $request->input('user');
        if(isset($user)){
        $userdata = DB_Tracking::where('uid',$user)->latest()->paginate(20);
        return view('admin.tracker',['userdata' => $userdata]);
        }
        $userdata = DB_Tracking::latest()->paginate(20);
        return view('admin.tracker',['userdata' => $userdata]);

    }
 

   public function wallpapers_list(Request $request)
    {
       $category = DB_Wallpaper::latest()->paginate(15);
       return view('admin.wallpaper.wallpaper', ['category'=>$category]);
    }


    public function delete_wallpaper($id)
    {
        DB_Wallpaper::find($id)->delete();
        return redirect()->back()->with('success', 'Wallpaper deleted successfully!');
    }
 
   public function quick_blist(Request $request)
    {
       $category = DB_QuickBonu::latest()->paginate(15);
       return view('admin.quick_bonus.quick_bonus', ['category'=>$category]);
    }


    public function delete_qbonus($id)
    {
        DB_QuickBonu::find($id)->delete();
        return redirect()->back()->with('success', 'Quick Bonus deleted successfully!');
    }

    public function payment_methodlist(Request $request)
    {
       $category = DB_Payment::latest()->paginate(15);
       return view('admin.payment.payment_method', ['redeem'=>$category]);
    }

   public function view_payment($id){
        $redeem = DB_Payment::find($id);
        return view('admin.payment.view_payment', ['user_data'=>$redeem]);
    }

    public function update_payment(Request $request, $id){

        $user = DB_Payment::find($id);
        $user->py_title =$request['py_title'];
        $user->py_rcoin =$request['py_rcoin'];
        $user->py_amout =$request['py_amout'];
        $user->py_inouthint =$request['py_inouthint'];
        $user->py_inputhint2 =$request['py_inputhint2'];
        $user->save();
        return redirect(route('admin.view_payment', ['id' => $id]))->with('status-success', 'User Has Been updated');
     

    }


    public function payment_method()
    {
        $redeem = DB_Payment::latest()->paginate(15);
        return view('admin.payment.payment_method', ['redeem'=>$redeem]);
    }

    public function payment_request()
    {
        $redeem = DB_PyRequest::latest()->paginate(15);
        return view('admin.payment.payment_request', ['redeems'=>$redeem]);
    }

    public function view_paymentrequest($id)
    {

        $redeem = DB_PyRequest::find($id);
        return view('admin.payment.view_paymentrequest', ['user_data'=>$redeem]);

    }


    public function paymentrequest_status($id,$id2){
          
        $user = DB_PyRequest::find($id);
        $user->status = $id2;
        $user->save();
        return redirect(route('admin.payment_request', ['id' => $id]))->with('status-success', 'Status Has Been updated');

    }


    public function push_notification(Request $request)
    {
 
        $request->validate([
            'title' => 'required|string',
            'full_text' => 'required|string',
            'img' => 'nullable|image|mimes:jpg,jpeg,png|max:2048',
            'url' => 'nullable|string',
        ]);

        $title = $request->input('title');
        $message = $request->input('full_text');
        $url = $request->input('url');
        $imageUrl = null;

        if ($request->hasFile('img')) {
            $imageName = time() . '.' . $request->file('img')->getClientOriginalExtension();
            $request->file('img')->move(public_path('uploads/notifications'), $imageName);
            $imageUrl = asset('uploads/notifications/' . $imageName);
        }

        $data = [
            'app_id' => env('ONESIGNAL_APP_ID'),
            'included_segments' => ['All'], // send to all users
            'headings' => ['en' => $title],
            'contents' => ['en' => $message],
        ];

        if ($imageUrl) {
            $data['big_picture'] = $imageUrl;
        }

        if ($url) {
            $data['url'] = $url;
            $data['data'] = ['custom_url' => $url];
        }

        $response = Http::withHeaders([
            'Authorization' => 'Basic ' . env('ONESIGNAL_API_KEY'),
            'Content-Type' => 'application/json',
        ])->post('https://onesignal.com/api/v1/notifications', $data);

        $py_item = new DB_Notification();
        $py_item->title = $title;
        $py_item->full_text = $message;
        $py_item->img = $imageUrl;
        $py_item->url = $url;
        $py_item->save();
        if ($response->successful()) {
             return redirect()->back()->with('success', '✅ Notification sent successfully!');
        } else {
            return redirect()->back()->with('status', '❌ Failed: ' . $response->body());
        }

    }

    public function send_notification(){
        return view('admin.notification.notification_send');
    }

    public function all_notification(){
        $redeem = DB_Notification::latest()->paginate(15);
        return view('admin.notification.notification', ['notification'=>$redeem]);
     }
     



   public function add_banner(){
        return view('admin.banner.add');
    }


    public function banner_list(){
        $redeem = ModelsDBanner::latest()->paginate(15);
        return view('admin.banner.banner', ['category'=>$redeem]);
     }
     

    

    public function add_bannerreq(Request $rq)
    {

        $banner = new ModelsDBanner();
        if ($rq->hasFile('image')) {
            $file = $rq->file('image');
            $extension = $file->getClientOriginalExtension();
            $filename = time() . '_' . uniqid() . '.' . $extension;
            $path = 'images/upload/banner';
            $file->move($path, $filename);
        }
        $banner->url = $rq['url'] ?? '';
        $banner->image = $filename;
        $banner->title = 'null';
        
        $banner->save();
        // Add a success message to session
        return redirect()->back()->with('success', 'Banner added successfully!');
       

    }


    public function delete_banner($id)
    {
        ModelsDBanner::find($id)->delete();
        return redirect()->back()->with('success', 'Banner deleted successfully!');
    }


    private function formatNumberShort($number)
    {
        if ($number >= 1000000) {
            return number_format($number / 1000000, 1) . 'M';
        } elseif ($number >= 1000) {
            return number_format($number / 1000, 1) . 'K';
        } else {
            return (string) $number;
        }
    }


    public function ad_unit()
    {
        $setting = DB_Settings::where('id',1)->first();
        return view('admin.add_setting.ad_unit', ['settings'=>$setting]);
    }


    public function update_adunit(Request $request)
    {
       
        $setting = DB_Settings::find(1);
        $newData = [
            'admob_appid' => $request->input('admob_appid'),
            'admob_bannerid' => $request->input('admob_bannerid'),
            'admob_intid' => $request->input('admob_intid'),
            'admob_rewardid' => $request->input('admob_rewardid'),
            'applovin_reward' => $request->input('applovin_reward'),
            'fb_rewardid' => $request->input('fb_rewardid'),
            'vungle_appid' => $request->input('vungle_appid'), 
            'vungle_rewardid' => $request->input('vungle_rewardid'),
            'inmobi_appid' => $request->input('inmobi_appid'),
            'inmobi_rewardid' => $request->input('inmobi_rewardid'),
            'vungle_appid' => $request->input('vungle_appid'),
            'vungle_rewardid' => $request->input('vungle_rewardid'),
            'facebook_test' => $request->input('facebook_test'),
            'fb_bannerid' => $request->input('fb_bannerid'),

        ];

        $setting->ad_unit = json_encode($newData);
        $setting->save();
    
        return redirect()->back()->with('success', 'Ad Unit Settings added successfully!');
    
    }



     public function admin_del_notification($id){
        DB::table('tv_notification')->where('id', $id)->delete();
        return redirect(route('admin.all_notification'))->with('status-success', 'notification Has Been deleted successfully.');

    
     }
 
 

    public function support(){
        $support = Tv_Support::latest()->paginate(15);
        return view('admin.support', ['support'=>$support]);
    }

 

    public function admin_settings(){

        $admin = Admin::where('id',1)->first();
        return view('admin.admin_setting', ['admin'=>$admin]);

    }

    public function updateadmin_settings(Request $req){ 

       $user = Admin::find(1);
       $user->name =$req['name'];
       $user->email =$req['email'];
       $user->password = Hash::make($req->password);
       $user->save();

       $admin = Admin::where('id',1)->first();
       return view('admin.admin_setting', ['admin'=>$admin]);

    }





    public function all_page(){
        $setting = DB_Settings::where('id',1)->first();
        return view('admin.page.all_page', ['pages'=>$setting]);

    }


    public function view_amount($id){
        $redeem = DB_Amount::where('amount_id', $id)->paginate(10);
        return view('admin.payment.amount_list', ['redeem' => $redeem, 'id' => $id]);
    }



    public function add_paymentamount($id, Request $req){

 
        $banner = new DB_Amount();
        $banner->py_rcoin = $req['py_rcoin'] ?? '';
        $banner->py_amout = $req['py_amout'] ?? '';
        $banner->amount_id = $id; 
        $banner->save();
        // Add a success message to session
        return redirect()->back()->with('success', 'Payment Amount added successfully!');
       
        
    }

    public function delete_amount($id)
    {
        DB_Amount::find($id)->delete();
        return redirect()->back()->with('success', 'Amount deleted successfully!');
    }

    public function add_payment_methodreq(Request $rq)
    {


        $py_item = new DB_Payment();
        $filename = null; // default value
        if ($rq->hasFile('py_logo')) {
            $file = $rq->file('py_logo');
            $extension = $file->getClientOriginalExtension();
            $filename = time() . '_' . uniqid() . '.' . $extension;
            $path = 'images/upload/payment';
            $file->move($path, $filename);
        }

        $py_item->py_title = $rq['py_title'] ?? '';
        $py_item->py_logo = $filename; // এখন safe
        $py_item->py_inouthint = $rq['py_inouthint'] ?? null;
        $py_item->py_inputhint2 = $rq['py_inputhint2'] ?? null; 
        $py_item->py_currency = $rq['py_currency'] ?? null;
        $py_item->save();
        return redirect()->back()->with('success', 'Payment Method added successfully!');

    }



public function delete_payment($id)
{
    DB_Payment::find($id)->delete();
    return redirect()->back()->with('success', 'Payment deleted successfully!');
}


public function game_settings()
{
    $setting = DB_Settings::where('id',1)->first();
    return view('admin.add_setting.game', ['settings'=>$setting]);
}


public function game_settingupdate(Request $request)
{

    $setting = DB_Settings::find(1);
    $newData = [
        'game_winreward_min' => $request->input('game_winreward_min'),
        'game_winreward_max' => $request->input('game_winreward_max'),
        'fallback_1' => $request->input('fallback_1'),
        'fallback_2' => $request->input('fallback_2'),

        
    ];
    $setting->game_config = json_encode($newData);
    $setting->save();
    return redirect()->back()->with('success', 'OfferWall Settings added successfully!');


}






}
