<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DB_Refer extends Model
{
    
    use HasFactory;
    protected $table = 'db_refer';
    protected $primaryKey = 'id';
    protected $fillable = ['u_id', 'r_uid', 'level', 'point', 'status'];

    public static function referralHistory($userId, $maxLevel = 2, $currentLevel = 1, &$totalCoins = 0, &$totalReferrals = 0, $processedUserIds = [])
    {

        if ($currentLevel > $maxLevel) return collect();
        $referrals = self::where('u_id', $userId)->get();
        foreach ($referrals as $referral) {
            if ($referral->referredUser) {
                $referral->referred_user = $referral->referredUser;

                if ($currentLevel === 1 && $referral->status == 1) {
                    $totalCoins += $referral->point;
                    $totalReferrals++;
                }

                $referral->level = $currentLevel;

                if (!in_array($referral->referred_user->id, $processedUserIds)) {
                    $processedUserIds[] = $referral->referred_user->id;
                    $referral->referral_history = self::referralHistory(
                        $referral->referred_user->u_id,
                        $maxLevel,
                        $currentLevel + 1,
                        $totalCoins,
                        $totalReferrals,
                        $processedUserIds
                    );
                }
            }
        }

        return $referrals;

    }

    public function referredUser()
    {
        return $this->belongsTo(AUser::class, 'r_uid', 'u_id');
    }

}
